<?php
session_start();
include "admin_header.php";
include "db.php";

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

// Defaults
$today = date('Y-m-d');
$office_filter = isset($_GET['office_name']) ? $_GET['office_name'] : "";
$date_filter = isset($_GET['sale_date']) ? $_GET['sale_date'] : $today;
$search_filter = isset($_GET['search']) ? trim($_GET['search']) : "";

// Get offices for filter dropdown
$offices = mysqli_query($conn, "SELECT DISTINCT office_name FROM sales ORDER BY office_name ASC");

// Build WHERE conditions
$where = "sale_date = '$date_filter'";
if (!empty($office_filter)) {
    $where .= " AND office_name = '" . mysqli_real_escape_string($conn, $office_filter) . "'";
}
if (!empty($search_filter)) {
    $search_safe = mysqli_real_escape_string($conn, $search_filter);
    $where .= " AND (customer_name LIKE '%$search_safe%' 
                 OR item_name LIKE '%$search_safe%'
                 OR description LIKE '%$search_safe%')";
}


$query = "SELECT * FROM sales WHERE $where ORDER BY sale_id DESC";
$result = mysqli_query($conn, $query);

// Totals
$total_payable = 0;
$total_paid = 0;
$total_balance = 0;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Daily Sales Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
    <h2 class="mb-3">Admin - Daily Sales Report</h2>
<a href="admin_dashboard.php" class="btn btn-secondary btn-sm" >Back to Dashboard</a>
<br>
<br>
    <!-- Filter Form -->
    <form method="GET" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-md-3 col-12">
                <select name="office_name" class="form-select">
                    <option value="">-- All Offices --</option>
                    <?php while ($row = mysqli_fetch_assoc($offices)): ?>
                        <option value="<?php echo $row['office_name']; ?>" 
                            <?php if ($office_filter == $row['office_name']) echo "selected"; ?>>
                            <?php echo $row['office_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="col-md-3 col-12">
                <input type="date" name="sale_date" class="form-control" value="<?php echo $date_filter; ?>">
            </div>
            <div class="col-md-3 col-12">
                <input type="search" name="search" class="form-control" 
       placeholder="Search customer, item, or description" 
       value="<?php echo htmlspecialchars($search_filter); ?>">

            </div>
            <div class="col-md-3 col-12">
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </div>
    </form>

   <!-- Export Button -->
<form method="POST" action="export_sales.php" class="mb-3">
    <input type="hidden" name="report_type" value="daily">
    <input type="hidden" name="sale_date" value="<?php echo $date_filter; ?>">
    <input type="hidden" name="office_name" value="<?php echo $office_filter; ?>">
    <input type="hidden" name="search" value="<?php echo htmlspecialchars($search_filter); ?>">
    <button type="submit" class="btn btn-success">Export CSV</button>
</form>



    <!-- Table -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Item</th>
                    <th>Description</th>
                    <th>Amount Payable</th>
                    <th>Amount Paid</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($result)): 
                        $total_payable += $row['amount_payable'];
                        $total_paid += $row['amount_paid'];
                        $total_balance += $row['balance'];
                    ?>
                        <tr>
                             <td><?= htmlspecialchars(date("d M Y", strtotime($row['sale_date']))) ?></td>
                            <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['item_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['description']); ?></td>
                            <td><?php echo number_format($row['amount_payable'], 2); ?></td>
                            <td><?php echo number_format($row['amount_paid'], 2); ?></td>
                            <td><?php echo number_format($row['balance'], 2); ?></td>
                        </tr>
                    <?php endwhile; ?>
                    <!-- Totals Row -->
                    <tr class="fw-bold">
                        <td colspan="4" class="text-end">TOTAL</td>
                        <td><?php echo number_format($total_payable, 2); ?></td>
                        <td><?php echo number_format($total_paid, 2); ?></td>
                        <td><?php echo number_format($total_balance, 2); ?></td>
                    </tr>
                <?php else: ?>
                    <tr><td colspan="7" class="text-center">No sales found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php include "footer.php"; ?>
</body>
</html>
