<?php
session_start();

include "db.php"; // Connect to DB

// Protect dashboard - only logged-in admins can view
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit;
}

// Get the logged-in admin username
$admin_username = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : "Admin";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

    <style>
        body {
            font-family: poppins, sans-serif;
        }
        .sidebar {
			
            min-height:100vh ;
            background: #212529;
            color: #fff;
            padding-top: 20px;
        }
        .sidebar a {
            color: #ddd;
            text-decoration: none;
            display: block;
            padding: 12px 20px;
            border-radius: 5px;
            margin: 5px 10px;
        }
        .sidebar a:hover {
            background: #495057;
            color: #fff;
        }
        .sidebar .logout-btn {
            background: #dc3545;
            color: #fff !important;
            text-align: center;
            margin-top: 20px;
        }
		
		@media only screen and (max-width: 600px) {
    .sidebar {
			
            min-height:26vh;
    }
}
    </style>
</head>
<body class="bg-light">

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 sidebar">
            <h4 class="text-center mb-4">📋 Admin Dashboard</h4>
            <p class="text-center">Welcome, <b><?php echo htmlspecialchars($admin_username); ?></b></p>
            
           <a href="admin_logout.php" class="logout-btn"><i class="bi bi-box-arrow-right"></i> Logout</a>
        </nav>

        <!-- Main Content -->
       <main class="col-md-9 col-lg-10 px-4 py-4">
    <h2 class="mb-4">📊 Sales Reports</h2>

    <div class="row g-4">
        <!-- Daily Sales Report -->
        <div class="col-md-4">
            <div class="card text-center shadow-lg border-0" style="min-height: 200px;">
                <div class="card-body text-white rounded-3 p-4" 
                     style="background: linear-gradient(100deg, #001233, #003eb3);">
                    <div class="mb-2">
                        <i class="bi bi-calendar-day" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title fw-bold">Daily Sales Report</h5>
                    <p class="card-text small">View sales breakdown for today.</p>
                    <a href="admin_daily_report.php" class="btn btn-light btn-sm fw-bold px-3">Go</a>
                </div>
            </div>
        </div>

        <!-- Weekly Sales Report -->
        <div class="col-md-4">
            <div class="card text-center shadow-lg border-0" style="min-height: 200px;">
                <div class="card-body text-white rounded-3 p-4" 
                     style="background: linear-gradient(100deg, #990000, #ff1a75);">
                    <div class="mb-2">
                        <i class="bi bi-calendar-week" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title fw-bold">Weekly Sales Report</h5>
                    <p class="card-text small">Analyze performance across the week.</p>
                    <a href="admin_weekly_report.php" class="btn btn-light btn-sm fw-bold px-3">Go</a>
                </div>
            </div>
        </div>

        <!-- Monthly Sales Report -->
        <div class="col-md-4">
            <div class="card text-center shadow-lg border-0" style="min-height: 200px;">
                <div class="card-body text-white rounded-3 p-4" 
                     style="background: linear-gradient(135deg, #001a4d, #38ef7d);">
                    <div class="mb-2">
                        <i class="bi bi-calendar-month" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title fw-bold">Monthly Sales Report</h5>
                    <p class="card-text small">Track progress and revenue this month.</p>
                    <a href="admin_monthly_report.php" class="btn btn-light btn-sm fw-bold px-3">Go</a>
                </div>
            </div>
        </div>
    </div>
</main>

    </div>
</div>

</body>
</html>
