<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

if (!isset($_GET['sale_id'])) {
    header("Location: dashboard.php");
    exit();
}

$sale_id = intval($_GET['sale_id']);

// Delete only if belongs to this user
$stmt = $conn->prepare("DELETE FROM sales WHERE sale_id = ? AND staff_id = ?");
$stmt->bind_param("ii", $sale_id, $user_id);
$stmt->execute();

$stmt->close();

header("Location: weekly_report.php");
exit();
