<!DOCTYPE html>
<html>
<head>
    <title>Sales Reporting System - Welcome</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(to right, #007bff, #00c6ff),url("bg.jpg");
			background-position:center;
			
			background-size:cover;
			background-blend-mode:multiply;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            color: white;
        }
        .welcome-box {
            background: rgba(255, 255, 255, 0.2);
            padding: 30px 20px;
            border-radius: 15px;
            backdrop-filter: blur(4px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 450px;
            text-align: center;
        }
        .btn-custom {
            width: 100%;
            font-size: 1.1rem;
            padding: 10px;
        }
        @media (min-width: 576px) {
            .btn-custom {
                width: 150px;
            }
        }
    </style>
</head>
<body>

<div class="welcome-box">
    <h1 class="fw-bold mb-3">Welcome to Classic Sales Reporting System</h1>
    <p class="mb-4">Easily manage sales and generate reports.</p>
    
    <div class="d-flex flex-column flex-sm-row justify-content-center gap-3">
        <a href="register.php" class="btn btn-light text-primary btn-custom"><i class="bi bi-person-plus"></i> Register</a>
        <a href="login.php" class="btn btn-primary btn-custom"><i class="bi bi-box-arrow-in-right"></i> Login</a>
    </div>

    <hr class="mt-4" style="background:white; opacity:0.4;">
    <small>&copy; <?php echo date("Y"); ?> Sales Reporting System. All Rights Reserved.</small>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
